#import <Foundation/Foundation.h>

// need to include the header for the fcFw framework
#import "fcDio32.h"



fcDio32*		gMyCard;					// reference to our card object, handles interaction with the FPCI-DIO32 PCI card.






// this routine demonstrates simple I/O operations to the data port using mode0
//

DoMode0IoPortTest()
{
	int				i;
	UInt32			value, readValue;
	BOOL			gotError;
	UInt32			saved_c_dio32_master_cntrl;
	UInt32			saved_c_dio32_mode0_data;
	UInt32			saved_c_dio32_mode0_cntrl;
	kern_return_t	ret;

	
	NSLog(@"Beginnning mode0 I/O port test\n");

	
	// first save the state of the registers we will be writting to
	// this allows us to restore the state of the card after we are done.
	// this demonstrates how to read from the registers on teh card.
	ret = [gMyCard fpciDio32x_GetMaster_Cntrl_Reg: &saved_c_dio32_master_cntrl];
	ret = [gMyCard fpciDio32x_GetMode0_Data_Reg: &saved_c_dio32_mode0_data];
	ret = [gMyCard fpciDio32x_GetMode0_Cntrl_Reg: &saved_c_dio32_mode0_cntrl];

	

	gotError = FALSE;
	
	// set mode 0, xtal clock source, no RTI clk, enable clk to customer I/O port
	ret = [gMyCard fpciDio32x_SetMaster_Cntrl_Reg: 0x00000004];	

	// set I/O signals to 'output' direction
	ret = [gMyCard fpciDio32x_SetMode0_Cntrl_Reg: 0x000000FF];	

	// sequence through the bits in the I/O port
	value = 1;
	for (i = 0; i < 33; i++)
		{
		// write new bit value
		ret = [gMyCard fpciDio32x_SetMode0_Data_Reg: value];	
		
		// read it back
		ret = [gMyCard fpciDio32x_GetMode0_Data_Reg: &readValue];
		
		if (readValue != value)
			{
			// got an error
			gotError = TRUE;
			}
		else
			{
			}
		
		// shift the pattern one bit to the left
		value = value << 1;
		value = value & 0xfffffffe;
		}

	// put everything back where we found it
	ret = [gMyCard fpciDio32x_SetMaster_Cntrl_Reg: saved_c_dio32_master_cntrl];	
	ret = [gMyCard fpciDio32x_SetMode0_Cntrl_Reg: saved_c_dio32_mode0_cntrl];	
	ret = [gMyCard fpciDio32x_SetMode0_Data_Reg: saved_c_dio32_mode0_data];	

	// report results
	if (gotError)
		NSLog(@"Found I/O errors!\n");
	else
		NSLog(@"No I/O errors found.\n");
	
}




// Test routine to demonstrate simple waveform generation. 
// We will use mode1 operation on the FPCI-DIO32 card and
// setup a waveform description in the card's memory that 
// will generate a shifting bit pattern from bit 0 toward
// bit 31 and then stop.  
//
// After the pattern is defined, we will run the waveform
// generator and then readback the waveform that was captured
// by the input memory buffer of the card.
//
// This waveform will use a single waveform segment to define
// the waveform.  The port's direction control lines will
// be set to all 'output' during the waveform playback.  The
// card will simultaneously capture the signal states on the
// I/O port while the waveform is playing.  We will then be
// able to read the captured data from the card's input memory
// to verify that the waveforms was correctly generated.
//
DoMode1IoWaveformGeneration_1()
{
	wvPatternWord		aPatternWord;
	int					i;
	kern_return_t		ret;
	UInt32				newFrequency;
    UInt32				myMode1CntrlValue;	
    Boolean				ready;
    Boolean				running;
	UInt32				theDataWord;
	UInt32				compareWord;
	BOOL				gotError;
	NSData*				inputDataRef;
	NSRange				aRange;
	UInt32				inputAddress;

	

	NSLog(@"Beginning mode0 I/O waveform generation #1.\n");
	
	
	// reset the mode1 command register before we begin
	[gMyCard fpciDio32x_SetMode1_Cntrl_Reg: 0x00000000];
	
	// We will first need to generate the waveform pattern in the 
	// memory on the card.  Start by clearing the memory array.
	[gMyCard clearWaveformDefinition];
	
	// waveforms are described by means of individual waveform segments.
	// Very long waveforms are described by chaining multiple waveform
	// segments together.
	//
	// Each waveform segment descriptor will have an array of pattern wards
	// to define how the waveform will look.  There is one pattern word
	// for each clock cycle of the waveform.
	//
	// In this example, we are generating a very short waveform and all
	// of our data pattern words will fit into a single waveform segment descriptor.
	//
	// Create a new waveform segment record for the first (and only)
	// segment of our waveform.
	[gMyCard newWvSegRecord];
	
	// setup a pattern word that will describe the signal states for a single
	// clock cycle when the waveform is played back.
	aPatternWord.flags = 0x00;				// no interrupts
	aPatternWord.dirCntrl = 0xff;			// all 32 bits as outputs for this clock cycle
	aPatternWord.patternData = 0x00000001;	// LSB its high
	
	// we will add 32 pattern words to the waveform segment.  Each new pattern
	// word will have the bit shifted one more position to the left.
	for (i = 0; i < 33; i++)
		{
		// add the next pattern word to the waveform definition
		[gMyCard addPatternWord2Segment: &aPatternWord atIndex: 0];
		
		// shift the pattern one bit to the left
		aPatternWord.patternData = aPatternWord.patternData << 1;
		aPatternWord.patternData = aPatternWord.patternData & 0xfffffffe;
		}
	
	
	// OK.  At this point we have created the definition of our desired waveform
	// in local memory.  Before we can play back the waveform, we need to upload it
	// to the card.
	[gMyCard uploadWaveformData2Hardware];
	
	
	// clear out the input memory array so that we know that new data was written to 
	// it when we capture the waveform being played back.
	inputAddress = 0x01000000;		// offset of the input memory array
	for (i = 0; i < 33; i++)
		{
		ret = [gMyCard fpciDio32x_SetInputMemoryAtAddress: inputAddress theData: 0x00000000];
		
		// point to the next memory location
		inputAddress = inputAddress + 0x00000004;	// four bytes per memory word
		}

	
	// set the frequency of the DDS clock generator.  this will set the rate
	// at which pattern words are generated from the card
	newFrequency = 1000000;		// 1 MHz
	ret = [gMyCard fpciDio32x_SetDDS_Frequency: newFrequency];



	// setup the board's master control register to allow:
	//		1) mode1 operation
	//		2) DDS Clock generator
	//		3) Enable clock to be driven on the I/O port
	//
	ret = [gMyCard fpciDio32x_SetMaster_Cntrl_Reg: 0x00000087];
	
	
	// now setup a sequence whereby we enable the card's mode1 logic
	ret = [gMyCard fpciDio32x_SetMode1_Cntrl_Reg: 0x00000000];	// reset mode1 logic
	ret = [gMyCard fpciDio32x_SetMode1_Cntrl_Reg: 0x00000004];	// enable
		
		
	NSLog(@"Waiting for mode1 logic to be ready.\n");

	// after we enable the mode1 logic, we poll for the trig_ready_status bit
	// to be high, signalling that we can issue a trigger command to begin waveform
	// playback.
	ready = false;
	while (!ready)
		{
		ret = [gMyCard fpciDio32x_GetMode1_Cntrl_Reg: &myMode1CntrlValue];
		myMode1CntrlValue = myMode1CntrlValue & 0x00000002;
		if (myMode1CntrlValue == 2)
			ready = true;
		}
			
	// the card is ready to begin waveform playback.
	// issue a software 'trigger' command to start it playing.
	ret = [gMyCard fpciDio32x_SetMode1_Cntrl_Reg: 0x0000000c];	// enable, and soft_trig
	
	
	// we can poll the 'run_status' bit to determine when the waveform is finished playing.
	// we first wait for it to go high
	running = false;
	while (!running)
		{
		ret = [gMyCard fpciDio32x_GetMode1_Cntrl_Reg: &myMode1CntrlValue];
		myMode1CntrlValue = myMode1CntrlValue & 0x00000001;
		if (myMode1CntrlValue == 1)
			running = true;
		}

	NSLog(@"Waveform generator running.\n");

	// now wait for it to go low
	running = true;
	while (running)
		{
		ret = [gMyCard fpciDio32x_GetMode1_Cntrl_Reg: &myMode1CntrlValue];
		myMode1CntrlValue = myMode1CntrlValue & 0x00000001;
		if (myMode1CntrlValue == 0)
			running = false;
		}

	NSLog(@"Waveform generation finished.\n");
	
	
	// OK.  At this point we should have finished playing back our desired waveform pattern
	//
	// we will read back the data that was captured in the card's imput memory buffer during
	// the playback sequence.  We will verify that the captured data is the same as the
	// waveform that we generated.
	
	// reset the mode1 command register
	[gMyCard fpciDio32x_SetMode1_Cntrl_Reg: 0x00000000];


	// get the captured input dta for the waveform segment.  We only used one waveform segment
	// so there is only one to get.
	inputDataRef = [gMyCard getInputWaveformWordsForIndex: 0];


	gotError = FALSE;		// assume no errors to start
	compareWord = 0x00000001;
	for (i = 0; i < 33; i++)
		{
		// get an input capture data sample
		aRange.location = i * 4;	
		aRange.length = 4;
		[inputDataRef getBytes: &theDataWord range: aRange];

		
		// this is where we test to see if we got what we were expecting
		if (compareWord != theDataWord)
			gotError = TRUE;

		compareWord = compareWord << 1;
		compareWord = compareWord & 0xfffffffe;
		
		}


	if (gotError)
		NSLog(@"Waveform generation failed.\n");
	else
		NSLog(@"Waveform generation succeeded!\n");


}







// Test routine to demonstrate more complex waveform generation. 
// We will use mode1 operation on the FPCI-DIO32 card and
// setup a waveform description in the card's memory that 
// will generate a binary count sequence on the port.
//
// The sequence will consist of:
//		1) 4-bit binary counter 0 -> 0xf repeates 10 times
//		2) clock signal running at 1/4 rate for 8 cycles
//
// The port signals used are:
//		1) port[3:0] = 4 bit counter
//		2) port[4]   = clock signal
//
// After the pattern is defined, we will run the waveform
// generator and then readback the waveform that was captured
// by the input memory buffer of the card.
//
// This waveform will test the following capabilities of the
// waveform generator logic:
//		1) multiple waveform segments
//		2) looping a specified number of times on a segment
//
// This waveform will use two waveform segments to define
// the waveform.  The port's direction control lines will
// be set to all 'output' during the waveform playback.  The
// card will simultaneously capture the signal states on the
// I/O port while the waveform is playing.  We will then be
// able to read the captured data from the card's input memory
// to verify that the waveforms was correctly generated.
//

DoMode1IoWaveformGeneration_2()
{
	wvPatternWord		aPatternWord;
	int					i;
	kern_return_t		ret;
	UInt32				newFrequency;
    UInt32				myMode1CntrlValue;	
    Boolean				ready;
    Boolean				running;
	UInt32				theDataWord;
	UInt32				compareWord;
	BOOL				gotError;
	NSData*				inputDataRef;
	NSRange				aRange;
	UInt32				inputAddress;
	BOOL				currentClockState;
	wvSegRecord*		aWvSegRecordPtr;

	

	NSLog(@"Beginning mode0 I/O waveform generation #2.\n");
	
	
	// reset the mode1 command register before we begin
	[gMyCard fpciDio32x_SetMode1_Cntrl_Reg: 0x00000000];
	
	// We will first need to generate the waveform pattern in the 
	// memory on the card.  Start by clearing the memory array.
	[gMyCard clearWaveformDefinition];
	
	// waveforms are described by means of individual waveform segments.
	// Very long waveforms are described by chaining multiple waveform
	// segments together.
	//
	// Each waveform segment descriptor will have an array of pattern wards
	// to define how the waveform will look.  There is one pattern word
	// for each clock cycle of the waveform.
	//
	// In this example, we are generating a waveform that will use two
	// waveform segment descriptors.  The first one will generate the
	// 4-bit binary ounter sequence.  The second one will generate the
	// clock signal.
	//
	// Create a new waveform segment record for the first segment of our waveform.
	[gMyCard newWvSegRecord];
	
	// setup a pattern word that will describe the signal states for a single
	// clock cycle when the waveform is played back.
	aPatternWord.flags = 0x00;				// no interrupts
	aPatternWord.dirCntrl = 0xff;			// all 32 bits as outputs for this clock cycle
	aPatternWord.patternData = 0x00000000;	// start the counter @ 0x0
	
	// we will add 16 pattern words to the waveform segment.  Each new pattern
	// word will have the count incremented.  We will make sure that we merge the
	// clock signal in with the count.
	currentClockState = FALSE;
	for (i = 0; i < 16; i++)
		{
		// merge in the clock signal into bit lane 4
		if (currentClockState)
			aPatternWord.patternData = aPatternWord.patternData | 0x10;

		// add the next pattern word to the waveform definition
		[gMyCard addPatternWord2Segment: &aPatternWord atIndex: 0];			// specify waveform segment 0
		
		// increment the count field
		aPatternWord.patternData = aPatternWord.patternData + 1;
		aPatternWord.patternData = aPatternWord.patternData & 0x0f;
					
		if ((i & 0x1) == 0x1)
			{
			currentClockState = !currentClockState;		// flip the clock signal state
			}
		}
	
	
	// at this point the first waveform segment is complete in its definition of 
	// one complete count sequence.  We wish to repeat this count sequence 2x
	// so we will store a '2' in the wv_repeat_count field for this segment.
	aWvSegRecordPtr = [gMyCard getWaveSegmentRecordAtIndex: 0];
	aWvSegRecordPtr->wv_repeat_count = 2;

	
	// now we will add another waveform segment that will finish out the clock signal states
	[gMyCard newWvSegRecord];
	
	// setup a pattern word that will describe the signal states for a single
	// clock cycle when the waveform is played back.
	aPatternWord.flags = 0x00;				// no interrupts
	aPatternWord.dirCntrl = 0xff;			// all 32 bits as outputs for this clock cycle
	aPatternWord.patternData = 0x00000000;	// start the counter @ 0x0
	
	// we will add 4 * 8 pattern words to the waveform segment.  
	// we want to generate a clock signal running at 1/4 the rate of the master
	// clock for the pattern generator so we need four pattern words / clock period.
	//
	// We will generate this waveform segment without looping by explicitly adding in 
	// as many pattern words as we need for the entire waveform segment.  this will be
	// a total of 32 pattern words.  4 per clock cycle times the 8 clock periods
	// we wish to generate = 32 pattern words.
	//
	currentClockState = FALSE;
	for (i = 0; i < 32; i++)
		{
		// merge in the clock signal into bit lane 4
		if (currentClockState)
			aPatternWord.patternData = 0x00000010;	// clock signal hi
		else
			aPatternWord.patternData = 0x00000000;	// clock signal lo
			
		// add the next pattern word to the waveform definition
		[gMyCard addPatternWord2Segment: &aPatternWord atIndex: 1];			// specify waveform segment 1
				
		if ((i & 0x1) == 0x1)
			{
			currentClockState = !currentClockState;		// flip the clock signal state
			}
		}
	



	// we add one more pattern word so that we finish with all 0's on the output
	aPatternWord.patternData = 0x00000000;
			
	// add the next pattern word to the waveform definition
	[gMyCard addPatternWord2Segment: &aPatternWord atIndex: 1];			// specify waveform segment 1
	
	
	
	
	
	
	// OK.  At this point we have created the definition of our desired waveform
	// in local memory.  Before we can play back the waveform, we need to upload it
	// to the card.
	[gMyCard uploadWaveformData2Hardware];
	
	
	// clear out the input memory array so that we know that new data was written to 
	// it when we capture the waveform being played back.
	inputAddress = 0x01000000;		// offset of the input memory array for waveform segment 0
	for (i = 0; i < 16; i++)
		{
		ret = [gMyCard fpciDio32x_SetInputMemoryAtAddress: inputAddress theData: 0x00000000];
		
		// point to the next memory location
		inputAddress = inputAddress + 0x00000004;	// four bytes per memory word
		}
	// do the same for the input memory where waveform segment 1 data will be
	inputAddress = 0x01000400;		// offset of the input memory array for waveform segment 1
	for (i = 0; i < 32; i++)
		{
		ret = [gMyCard fpciDio32x_SetInputMemoryAtAddress: inputAddress theData: 0x00000000];
		
		// point to the next memory location
		inputAddress = inputAddress + 0x00000004;	// four bytes per memory word
		}

	
	// set the frequency of the DDS clock generator.  this will set the rate
	// at which pattern words are generated from the card
	newFrequency = 1000000;		// 1MHz
	ret = [gMyCard fpciDio32x_SetDDS_Frequency: newFrequency];



	// setup the board's master control register to allow:
	//		1) mode1 operation
	//		2) DDS Clock generator
	//		3) Enable clock to be driven on the I/O port
	//
	ret = [gMyCard fpciDio32x_SetMaster_Cntrl_Reg: 0x00000087];
	
	
	// now setup a sequence whereby we enable the card's mode1 logic
	ret = [gMyCard fpciDio32x_SetMode1_Cntrl_Reg: 0x00000000];	// reset mode1 logic
	ret = [gMyCard fpciDio32x_SetMode1_Cntrl_Reg: 0x00000004];	// enable
		
		
	NSLog(@"Waiting for mode1 logic to be ready.\n");

	// after we enable the mode1 logic, we poll for the trig_ready_status bit
	// to be high, signalling that we can issue a trigger command to begin waveform
	// playback.
	ready = false;
	while (!ready)
		{
		ret = [gMyCard fpciDio32x_GetMode1_Cntrl_Reg: &myMode1CntrlValue];
		myMode1CntrlValue = myMode1CntrlValue & 0x00000002;
		if (myMode1CntrlValue == 2)
			ready = true;
		}
			
	// the card is ready to begin waveform playback.
	// issue a software 'trigger' command to start it playing.
	ret = [gMyCard fpciDio32x_SetMode1_Cntrl_Reg: 0x0000000c];	// enable, and soft_trig
	
	
	// we can poll the 'run_status' bit to determine when the waveform is finished playing.
	// we first wait for it to go high
	running = false;
	while (!running)
		{
		ret = [gMyCard fpciDio32x_GetMode1_Cntrl_Reg: &myMode1CntrlValue];
		myMode1CntrlValue = myMode1CntrlValue & 0x00000001;
		if (myMode1CntrlValue == 1)
			running = true;
		}

	NSLog(@"Waveform generator running.\n");

	// now wait for it to go low
	running = true;
	while (running)
		{
		ret = [gMyCard fpciDio32x_GetMode1_Cntrl_Reg: &myMode1CntrlValue];
		myMode1CntrlValue = myMode1CntrlValue & 0x00000001;
		if (myMode1CntrlValue == 0)
			running = false;
		}

	NSLog(@"Waveform generation finished.\n");
	
	
	// OK.  At this point we should have finished playing back our desired waveform pattern
	//
	// we will read back the data that was captured in the card's imput memory buffer during
	// the playback sequence.  We will verify that the captured data is the same as the
	// waveform that we generated.
	
	// reset the mode1 command register
	[gMyCard fpciDio32x_SetMode1_Cntrl_Reg: 0x00000000];


	// get the captured input data for the waveform segment 0.  
	inputDataRef = [gMyCard getInputWaveformWordsForIndex: 0];


	gotError = FALSE;		// assume no errors to start
	compareWord = 0x00000000;
	currentClockState = FALSE;
	for (i = 0; i < 16; i++)
		{
		if (currentClockState)
			compareWord = compareWord | 0x10;

		// get an input capture data sample
		aRange.location = i * 4;	
		aRange.length = 4;
		[inputDataRef getBytes: &theDataWord range: aRange];

		
		// this is where we test to see if we got what we were expecting
		if (compareWord != theDataWord)
			gotError = TRUE;

		// look for the next anticipated count state 
		compareWord = compareWord + 1;
		compareWord = compareWord & 0x0f;
		
		// look for the next anticipated clock state
		if ((i & 0x1) == 0x1)
			{
			currentClockState = !currentClockState;		// flip the clock signal state
			}
		}

	// get the captured input data for the waveform segment 1.  
	inputDataRef = [gMyCard getInputWaveformWordsForIndex: 1];


	compareWord = 0x00000000;
	currentClockState = FALSE;
	for (i = 0; i < 32; i++)
		{
		if (currentClockState)
			compareWord = 0x00000010;	// clock signal hi
		else
			compareWord = 0x00000000;	// clock signal lo

		// get an input capture data sample
		aRange.location = i * 4;	
		aRange.length = 4;
		[inputDataRef getBytes: &theDataWord range: aRange];

		
		// this is where we test to see if we got what we were expecting
		if (compareWord != theDataWord)
			gotError = TRUE;

		// look for the next anticipated clock state
		if ((i & 0x1) == 0x1)
			{
			currentClockState = !currentClockState;		// flip the clock signal state
			}
		
		}



	if (gotError)
		NSLog(@"Waveform generation failed.\n");
	else
		NSLog(@"Waveform generation succeeded!\n");


}







int main (int argc, const char * argv[]) {
    NSAutoreleasePool * pool = [[NSAutoreleasePool alloc] init];

	
	// create the software object that I will use to communicate with the card
	gMyCard = [[fcDio32 alloc] init];
	
	
	// perform some basic programatic I/O operations using mode0 
	DoMode0IoPortTest();
	
	
	// perform simple waveform pattern test.
	// single waveform segment with a shifted bit pattern on the port.
	DoMode1IoWaveformGeneration_1();
	
	
	// perform waveform generation with multiple waveform segments and looping
	DoMode1IoWaveformGeneration_2();

	
	// all done with the card so release the card object
	[gMyCard CloseCardConnection];



    [pool release];
    return 0;
}
